var versionNumber = '1.0';

var defaultEventDate = '1/1';
var defaultEventName = 'New Year\'s Day';
var eventDate = defaultEventDate;
var eventName = defaultEventName;

function init() {
	widget.onhide = onhide;
	widget.onshow = onshow;
	widget.onremove = onremove;
	
	// If there are pre-saved prefs, load them.
	var eventDateTemp = widget.preferenceForKey( createKey( 'eventDate' ) );
	var eventNameTemp = widget.preferenceForKey( createKey( 'eventName' ) );
	if ( eventDateTemp ) eventDate = eventDateTemp;
	if ( eventNameTemp ) eventName = eventNameTemp;

	onshow();
}

function onremove() {
	widget.setPreferenceForKey( null, createKey( 'eventDate' ) );
	widget.setPreferenceForKey( null, createKey( 'eventName' ) );
}

function createKey( keyName ) {
	return widget.identifier + '-' + keyName;
}

var timerInterval = null;
function onshow() {
	if ( !flipped )	updateTime();
	if ( timerInterval == null ) {
		timerInterval = setInterval("updateTime();", 60000);
	}
}

function onhide() {
	if ( timerInterval != null ) {
		clearInterval(timerInterval);
		timerInterval = null;
	}
}

function resize()
{
/*
	size = SizePref.value;
	if ( size < 25 ) { size = 25; }
	
	mainWindow.height = 130*size/100;
	mainWindow.width = 130*size/100;
	background.height = 130*size/100;
	background.width = 130*size/100;
	daysLeftText.size = 40*size/100;
	daysLeftText.hOffset = 65*size/100;
	daysLeftText.vOffset = 60*size/100;
	daysUntilText.size = 12*size/100;
	daysUntilText.hOffset = 65*size/100;
	daysUntilText.vOffset = 74*size/100;
	eventNameText.size = 14*size/100;
	eventNameText.hOffset = 65*size/100;
	eventNameText.vOffset = 88*size/100;
*/
}

var flipped = false;
function flip() {
	if ( window.widget ) {
		if ( ! flipped ) {
			widget.prepareForTransition('ToBack');
			document.getElementById( "eventDateField" ).value = eventDate;
			document.getElementById( "eventNameField" ).value = eventName;
			document.getElementById( "widgetFront" ).style.display = 'none';
			document.getElementById( "widgetBack" ).style.display = 'block';
		}
		else {
			widget.prepareForTransition('ToFront');
			eventDate = document.getElementById( "eventDateField" ).value;
			eventName = document.getElementById( "eventNameField" ).value;
			widget.setPreferenceForKey( eventDate, createKey( "eventDate" ) );
			widget.setPreferenceForKey( eventName, createKey( "eventName" ) );
			document.getElementById( "widgetFront" ).style.display = 'block';
			document.getElementById( "widgetBack" ).style.display = 'none';
			updateTime();
		}
		setTimeout( 'widget.performTransition();', 0 );
		flipped = !flipped;
	}
}

function updateTime()
{
	var thisEventDate = eventDate;
	var thisEventName = eventName;
	
	// Calculate the time in milliseconds for midnight on that day.
	var now = new Date();
	var nowYear = now.getYear() + 1900;
	var nowMonth = now.getMonth() + 1;
	var nowDay = now.getDate();
	var nowString = nowMonth + "/" + nowDay + "/" + nowYear;
	var nowMillis = Date.parse( nowString );

	var eventDateValues = thisEventDate.split( '/' );
	if ( eventDateValues.length < 2 ) {
		eventDateValues = thisEventDate.split( '-' );
		if ( eventDateValues.length < 2 ) {
			eventDateValues = defaultEventDate.split( '/' );
			thisEventName = defaultEventName;
		}
	}
	var eventMonth = eventDateValues[0];
	var eventDay = eventDateValues[1];
	var assumeYear = false;
	var eventYear;
	if ( eventDateValues.length == 3 ) {
		eventYear = eventDateValues[2];
	}
	else {
		assumeYear = true;
		eventYear = nowYear;
	}
	
	var eventDateMillis = Date.parse( eventMonth + '/' + eventDay + '/' + eventYear );

	// If the difference in the times is negative, we assumed the wrong year.
	if ( ( assumeYear ) && ( eventDateMillis - nowMillis < 0 ) ) {
		var dateToParse = eventMonth + '/' + eventDay + '/' + ( parseInt( nowYear ) + 1 );
		eventDateMillis = Date.parse( dateToParse );
	}

	var daysLeft = Math.ceil( (eventDateMillis - nowMillis) / 86400000 );
	if ( daysLeft < 0 ) {
		document.getElementById( "daysLeftText" ).innerHTML = String( -daysLeft );
	}
	else {
		document.getElementById( "daysLeftText" ).innerHTML = String( daysLeft );
	}

	if ( daysLeft < 0 ) {
		if ( daysLeft == -1 ) {
			document.getElementById( "daysUntilText" ).innerHTML = "day since";
		}
		else {
			document.getElementById( "daysUntilText" ).innerHTML = "days since";
		}
	}
	else {
		if ( daysLeft == 1 ) {
			document.getElementById( "daysUntilText" ).innerHTML = "day until";
		}
		else {
			document.getElementById( "daysUntilText" ).innerHTML = "days until";
		}
	}
	
	document.getElementById( "eventNameText" ).innerHTML = thisEventName + "!";
}

function showAbout() {
	widget.openURL('http://www.c3images.com/dashboard/aboutCountdown.html?version=' + versionNumber);
}

var prefsButtonShown = false;
function fadePrefsIn() {
	if ( ! prefsButtonShown ) {
		fade( document.getElementById( "prefsButton" ), 0.0, .7, 500 );
		prefsButtonShown = true;
	}
}

function fadePrefsOut() {
	if ( prefsButtonShown ) {
		fade( document.getElementById( "prefsButton" ), .7, 0.0, 500 );
		prefsButtonShown = false;
	}
}

// FADING SUPPORT
// *****************************
var framerate = 20;
var fadeTimer;
function fade( fadeImage, startOpacity, endOpacity, duration, callback ) {
	fadeImage.style.visibility = 'visible';
	fadeImage.style.opacity = startOpacity;
	if ( fadeTimer != null ) {
		clearInterval( fadeTimer );
		fadeTimer = null;
	}
	fadeTimer = setInterval( fadeSupport, framerate, fadeImage, startOpacity, endOpacity, duration, callback );
}

function fadeSupport( fadeImage, startOpacity, endOpacity, duration, callback ) {
	var stopIt;
	if ( endOpacity - startOpacity > 0 ) {
		stopIt = ( fadeImage.style.opacity >= endOpacity );
	}
	else {
		stopIt = ( fadeImage.style.opacity <= endOpacity );
	}
	if ( stopIt ) {
		clearInterval( fadeTimer );
		fadeTimer = null;
		fadeImage.style.opacity = endOpacity;
		if ( fadeImage.style.opacity <= 0 ) fadeImage.style.visibility = 'hidden';
		if ( callback ) callback();
	}
	else {
		opacityChangePerFrame = (endOpacity-startOpacity) / (duration/framerate);
		// the opacity parameter freaks out if we send it something very small, i.e., 1.5e-18, so we need to round it to the nearest hundredth.
		var newOpacity = parseInt((parseFloat( fadeImage.style.opacity ) + parseFloat( opacityChangePerFrame ))*100)/100;
		fadeImage.style.opacity = newOpacity;
	}
}
